*===============================================================================
/* Bruno Merlevede and Angelos Theodorakopoulos, "Productivity Effects of 
   Internationalisation through the Domestic Supply Chain", 
   Journal of Applied Econometrics, forthcoming.  */
*===============================================================================

*--------------------------SET-UP & READ DIRECTORIES----------------------------
cd													// Current directory of code
do "[0.0] directories.do"

*-----------------------------INSTALL PACKAGES----------------------------------
/*The commented part below describes some of the key packages used. Depending on
  whether already installed in the system you might need to add more packages 
  when running the code below. */

/* Mata
cap ssc install moremata, replace
cap adoupdate moremata, update

* Gtools
local github "https://raw.githubusercontent.com"
net install gtools, from(`github'/mcaceresb/stata-gtools/master/build/)
gtools, up

* Ftools
ssc install ftools
net install ftools, from(https://github.com/sergiocorreia/ftools/raw/master/src/)
ftools, compile

* reghdfe 5.x
ssc install reghdfe
cap ado uninstall reghdfe
net install reghdfe, from("https://raw.githubusercontent.com/sergiocorreia/reghdfe/master/src/")
reghdfe, compile

* Other
cap ssc install bacon
cap ssc install estout      */

*------------------------------RUN MASTER----------------------------------

* Compute intra- and inter-industry proxies using WIOD data 
/*Note: The WIOD data are available on (http://www.wiod.org/database/wiots16). 
  We use the “WIOT tables in STATA format” download. */
do "$code/[1.0] proxies.do" 							// Proxies
do "$code/[1.0] proxies_development_split.do"  			// Proxies split based on the level of development for each country
do "$code/[1.0] proxies_IV1" 							// First set of Instrumental Variables (IV1) for proxies (see equation 7 in paper)
do "$code/[1.0] proxies_IV1noUS" 						// First set of Instrumental Variables exc. US (IV1noUS) for proxies (see equation 7 in paper)
do "$code/[1.0] proxies_IV2" 							// Second set of Instrumental Variables (IV1) for proxies (see equations 8-9 in paper)
do "$code/[1.0] proxies_IV2noUS" 						// Second set of Instrumental Variables exc. US (IV1noUS) for proxies (see equations 8-9 in paper)

* Clean and prepare Amadeus firm-level and other relevant datasets
/*Note: The Orbis-Amadeus firm-level dataset used in the paper is purchased 
  from the commercial provider Bureau van Dijk (see https://www.bvdinfo.com) 
  - A Moody’s Analytics Company, and thus we are not allowed to make the data 
  public. We extended the dataset constructed by Merlevede et al. (2015) with 
  newer data. Merlevede et al. (2015) describes the procedure which is along 
  the lines of Kalemli-Ozcan et al. (2015).
  References:
  1) Merlevede, B., M. de Zwaan, K. Lenaerts, and V. Purice, 2015, Multinational networks, domestic and foreign firms in Europe. 
  Working Paper D/2015/7012/02, Working Papers of Faculty of Economics and Business Administration, Ghent University, Belgium.

  2) Sebnem Kalemli-Ozcan, Bent Sorensen, Carolina Villegas-Sanchez, Vadym Volosovych, and Sevcan Yesiltas, 2015, How to Construct 
  Nationally Representative Firm Level Data from the Orbis Global Database: New Facts and Aggregate Implications, NBER Working Paper Paper No. 21558 (Revised December 2019) */
do "$code/[2.0] clean_firm-dataset.do" 					// Import and clean raw data
do "$code/[3.0] trim_firm-dataset.do" 					// Trim outliers estimation and keep firms with at least three consecutive years observed in the data
do "$code/[3.1] create_lag_proxies.do" 					// Create a dataset with lagged values for proxies other than those used in the Baseline estimation

* Estimations
do "$code/[4.0] estimations.do" 						// Manuscript 
do "$code/[4.0] estimations_online_appendix.do" 		// Online Appendix
/*Note: also use files [4.1] regressors_IV_FE.do; [4.2] program_bootstrap.do; 
  & [4.2] TFP.do, where the 2 latter use sub-files for estimation of production 
  function: [4.2_sub] pf_estimation_PC.do; and [4.2_sub] pf_estimation_IC.do */

* Summary statistics (tables and figures)
do "$code/[5.0] sumstats.do" 							// For firm-level data
do "$code/[5.1] sumstats_proxies.do" 					// For proxies

* Other relevant results
do "$code/[5.2] short&long-run_effects.do" 				// Compute short and long-run effects for certain estimated models
do "$code/[5.3] KLintensity.do" 						// Find capital/labor intensive industries (KL)
do "$code/[5.4] upstreamness.do" 						// Compute upstreamness measure following: Fally (2011); and Antras, Chor, Fally & Hillberry (2012)

* Export tex tables with estimated results
do "$code/[6.0] export_tex_tables.do"
